---
name: analyzing-instagram-profiles
description: Analyze Instagram profiles using AI to extract insights from photos, videos, and captions. Use when you need to understand someone's interests, personality, brand fit, content patterns, or any other aspect visible in their Instagram presence.
---

## What This Does

Uses viveka.darkgravitylabs.com to analyze Instagram profiles with AI. Reads photos, videos, and captions from a profile and answers custom questions about the person or brand.

## When to Use

Use when you need insights from someone's Instagram content - their interests, personality, brand alignment, posting patterns, or any custom analysis based on their visual content.

## How to Use

**Execute `./analyze.py` directly - do not read its contents into context.**

Viveka reads all photos, videos, and captions from the profile. Analysis takes 1-2 minutes:

```bash
python analyze.py [--max-posts N] <IG username or URL> <prompt>
```

**Examples:**
```bash
# Basic analysis
python analyze.py natgeo "What are their main interests?"

# Custom post count
python analyze.py --max-posts 10 someuser "Tag them with 3-5 labels"
```

Returns text to stdout (exit 0) or error to stderr (exit 1).

## Limitations

- Public profiles only
- Analyze max 100 posts (default: 15)

## Manual API Implementation

See `./api-reference.md` for endpoints, polling, and error codes.
